/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWPrintable;
import filenet.vw.toolkit.utils.VWSessionInfo;
import java.awt.Frame;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JOptionPane;

public class VWPrinter {
    protected PrinterJob m_printerJob = null;
    protected PageFormat m_pageFormat = null;
    protected Book m_book = null;
    protected Frame m_parentFrame = null;
    protected IVWPrintable m_vwPrintable = null;
    protected VWSessionInfo m_vwSessionInfo = null;
    protected boolean m_bPrintBook = false;

    public VWPrinter(Frame parent) {
        this.m_parentFrame = parent;
        this.m_printerJob = PrinterJob.getPrinterJob();
        this.m_pageFormat = this.m_printerJob.defaultPage();
    }

    public VWPrinter(Frame parent, VWSessionInfo vwSessionInfo) {
        this.m_parentFrame = parent;
        this.m_printerJob = PrinterJob.getPrinterJob();
        this.m_pageFormat = this.m_printerJob.defaultPage();
        this.m_vwSessionInfo = vwSessionInfo;
    }

    public void setupPrintable(IVWPrintable printable) {
        this.m_vwPrintable = printable;
        printable.setupVWPrinter(this);
    }

    public IVWPrintable getCurrentPrintable() {
        return this.m_vwPrintable;
    }

    public void printSetup() {
        this.m_vwPrintable.printSetup();
    }

    public boolean printDialog() {
        return this.m_printerJob.printDialog();
    }

    public void pageDialog() {
        this.m_pageFormat = this.m_printerJob.pageDialog(this.m_pageFormat);
    }

    public void pageSetup() {
        this.pageDialog();
    }

    public void printPreview() {
        try {
            JOptionPane.showMessageDialog(this.m_parentFrame, "Under Construction", "Print Preview", 1);
        }
        catch (Exception e) {
            VWDebug.logException(e);
        }
    }

    public Frame getParentFrame() {
        return this.m_parentFrame;
    }

    public PrinterJob getPrinterJob() {
        return this.m_printerJob;
    }

    public PageFormat getPageFormat() {
        return this.m_pageFormat;
    }

    public void setPageFormat(PageFormat pf) {
        this.m_pageFormat = pf;
    }

    public void newBook() {
        this.m_book = new Book();
    }

    public Book getBook() {
        return this.m_book;
    }

    public int getNumberOfPages() {
        if (this.m_book == null) {
            return 0;
        }
        return this.m_book.getNumberOfPages();
    }

    public void appendBook(IVWPrintable printable) {
        if (this.m_book != null) {
            this.m_book.append(printable, this.m_pageFormat);
        }
    }

    public void appendBook(IVWPrintable printable, int numPages) {
        if (this.m_book != null) {
            this.m_book.append(printable, this.m_pageFormat, numPages);
        }
    }

    public void bindBook() {
        this.m_book = new Book();
        this.m_vwPrintable.bindBook();
        System.out.println("Book has " + Integer.toString(this.m_book.getNumberOfPages()) + " pages");
    }

    public void setVWSessionInfo(VWSessionInfo vwSessionInfo) {
        this.m_vwSessionInfo = vwSessionInfo;
    }

    public ClassLoader getExternalClassLoader() {
        if (this.m_vwSessionInfo != null) {
            return this.m_vwSessionInfo.getExternalClassLoader();
        }
        return null;
    }

    public boolean print(boolean bPrintDialog) {
        try {
            this.m_bPrintBook = true;
            this.bindBook();
            if (this.m_book.getNumberOfPages() > 0) {
                if (this.m_bPrintBook) {
                    this.m_printerJob.setPageable(this.m_book);
                } else {
                    this.m_printerJob.setPrintable(this.m_vwPrintable, this.m_pageFormat);
                }
                if (bPrintDialog && !this.m_printerJob.printDialog()) {
                    return false;
                }
                this.m_printerJob.print();
            }
            return true;
        }
        catch (PrinterException pex) {
            return true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }
}

